--[[ Screen Filter ]]
local numPlayers = GAMESTATE:GetNumPlayersEnabled()
local center1P = PREFSMAN:GetPreference("Center1Player")
local padding = 12 -- 10px on each side
local arrowWidth = 64 -- until noteskin metrics are implemented...

local filterColor = color("#000000")
local filterAlphas = {
	PlayerNumber_P1 = 1,
	PlayerNumber_P2 = 1,
	Default = 0,
}

local t = Def.ActorFrame{};

local function LifeMeterLength()
	local Style = GAMESTATE:GetCurrentStyle():GetStyleType()
	local sName = GAMESTATE:GetCurrentStyle():GetName()
	local Techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	local filterLength = 0
	
	if Techno or sName == "solo" or sName == "double" then
		filterLength = 640
	elseif Style == 'StyleType_OnePlayerOneSide' then
		filterLength = 392
	elseif Style == 'StyleType_TwoPlayersTwoSides' then
		filterLength = Width()/2
	end
	return filterLength
end

local Techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
local style = GAMESTATE:GetCurrentStyle()
local sName = GAMESTATE:GetCurrentStyle():GetName()
local cols = style:ColumnsPerPlayer()
local styleType = ToEnumShortString(style:GetStyleType())
--local filterWidth = (arrowWidth * cols) + padding
local filterWidth = LifeMeterLength()

if numPlayers == 1 then
	local player = GAMESTATE:GetMasterPlayerNumber()
	local pNum = (player == PLAYER_1) and 1 or 2
	filterAlphas[player] = tonumber(getenv("ScreenFilterP"..pNum));

	local pos, hAlign
	if Techno or sName == "solo" or sName == "double" then
		pos = CenterX() hAlign = 0.5
	else
		if pNum == 1 then pos = Left() hAlign = 0 else pos = Right() hAlign = 1 end
	end
	
	t[#t+1] = Def.Quad{
		Name="SinglePlayerFilter";
		InitCommand=cmd(x,pos;CenterY;zoomto,filterWidth,SCREEN_HEIGHT-80;diffusecolor,filterColor;diffusealpha,filterAlphas[player];halign,hAlign);
	};
else
	-- otherwise we need two separate ones. to the pairsmobile!
	for i, player in ipairs(PlayerNumber) do
		local pNum = (player == PLAYER_1) and 1 or 2
		filterAlphas[player] = tonumber(getenv("ScreenFilterP"..pNum));
		
		local pos, hAlign
		if Techno or sName == "solo" or sName == "double" then
			pos = CenterX() hAlign = 0.5
		else
			if pNum == 1 then pos = Left() hAlign = 0 else pos = Right() hAlign = 1 end
		end
		
		t[#t+1] = Def.Quad{
			Name="Player"..pNum.."Filter";
			InitCommand=cmd(x,pos;CenterY;zoomto,filterWidth,SCREEN_HEIGHT-80;diffusecolor,filterColor;diffusealpha,filterAlphas[player];halign,hAlign);
		};
	end
end

return t;